uniform sampler2D waves;
uniform sampler2D mask;
uniform float fade;
uniform bool hasMask;
uniform float waveIdx;
uniform float loopIn;
uniform float loopOut;

//Alternative version without loop that only draws one wave at a time
void main()
{
	vec2 uv = gl_TexCoord[0].st;
	vec4 c = gl_Color;

	float a = smoothstep(0.0, fade, min(uv.x, 1.0-uv.x));
	vec4 color = vec4(0.0,0.0,0.0,0.0);

	float h = texture2D(waves, vec2(uv.x, waveIdx)).x;
	c.rgb *= a;
	if (uv.y >= 1.0-h)
		color = c;

	float ca = step(loopIn, uv.x)*step(uv.x, loopOut);
	if (ca > 0.0)
	{
		c.rgb *= (1.0-uv.y);
		color = max(color, c);
	}

	if (hasMask)
		color.rgb *= texture2D(mask, uv).a;

	gl_FragColor = color;
}
